---@meta

---@class FAppleARKitLiveLinkConnectionSettings
---@field Port int32
local FAppleARKitLiveLinkConnectionSettings = {}



---@class FNetQuantizeFaceCurve
local FNetQuantizeFaceCurve = {}


---@class UAppleARKitFaceMeshComponent : UProceduralMeshComponent
---@field bWantsMeshUpdates boolean
---@field bWantsCollision boolean
---@field bAutoBindToLocalFaceMesh boolean
---@field TransformSetting EARFaceComponentTransformMixing
---@field bFlipTrackedRotation boolean
---@field FaceMaterial UMaterialInterface
---@field LiveLinkSubjectName FName
---@field RemoteCurves TArray<FNetQuantizeFaceCurve>
local UAppleARKitFaceMeshComponent = {}

function UAppleARKitFaceMeshComponent:UpdateMeshFromBlendShapes() end
---@param Vertices TArray<FVector>
function UAppleARKitFaceMeshComponent:UpdateMesh(Vertices) end
---@param InBlendShapes TMap<EARFaceBlendShape, float>
function UAppleARKitFaceMeshComponent:SetBlendShapes(InBlendShapes) end
---@param BlendShape EARFaceBlendShape
---@param Amount float
function UAppleARKitFaceMeshComponent:SetBlendShapeAmount(BlendShape, Amount) end
---@param bAutoBind boolean
function UAppleARKitFaceMeshComponent:SetAutoBind(bAutoBind) end
---@param ClientCurves TArray<FNetQuantizeFaceCurve>
function UAppleARKitFaceMeshComponent:ServerUpdateFaceCurves(ClientCurves) end
---@param SubjectName FName
function UAppleARKitFaceMeshComponent:PublishViaLiveLink(SubjectName) end
function UAppleARKitFaceMeshComponent:OnRep_RemoteCurves() end
---@return FTransform
function UAppleARKitFaceMeshComponent:GetTransform() end
---@return float
function UAppleARKitFaceMeshComponent:GetLastUpdateTimestamp() end
---@return int32
function UAppleARKitFaceMeshComponent:GetLastUpdateFrameNumber() end
---@param BlendShape EARFaceBlendShape
---@return float
function UAppleARKitFaceMeshComponent:GetFaceBlendShapeAmount(BlendShape) end
---@param Vertices TArray<FVector>
---@param Triangles TArray<int32>
---@param UV0 TArray<FVector2D>
function UAppleARKitFaceMeshComponent:CreateMesh(Vertices, Triangles, UV0) end


---@class UAppleARKitLiveLinkSourceFactory : ULiveLinkSourceFactory
local UAppleARKitLiveLinkSourceFactory = {}


